/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.util.HexDump;

public class IPSlipUtil {
    public static final byte END = -64;
    public static final byte ESC = -37;
    public static final byte ESC_END = -36;
    public static final byte ESC_ESC = -35;

    public static void main(String[] stringArray) {
        System.out.println("IPSlipUtil unit test");
        byte[] byArray = new byte[]{69, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, -64, -88, 0, -37, 16, 17, -1, 19, 20};
        System.out.println("ipPacket = " + new HexDump(byArray));
        System.out.println("isValid = " + IPSlipUtil.isValidIPv4(byArray, 0, byArray.length));
        byte[] byArray2 = IPSlipUtil.getSourceIPFromIPv4Packet(byArray, 0);
        byte[] byArray3 = IPSlipUtil.getTargetIPFromIPv4Packet(byArray, 0);
        System.out.println("source = " + IPSlipUtil.convertIPToString(byArray2));
        System.out.println("target = " + IPSlipUtil.convertIPToString(byArray3));
        byte[] byArray4 = new byte[]{1, -64, 2, -37, 3, -36, 4, -35, 5};
        System.out.println("constants = " + new HexDump(byArray4));
        byte[] byArray5 = new byte[1024];
        int n = IPSlipUtil.slipEncode(byArray, 0, byArray.length, byArray5, 0);
        byte[] byArray6 = new byte[n];
        System.arraycopy(byArray5, 0, byArray6, 0, n);
        System.out.println("slipencoded:" + new HexDump(byArray6));
        int n2 = IPSlipUtil.slipDecode(byArray6, 1, byArray6.length - 1, byArray5, 0);
        byte[] byArray7 = new byte[n2];
        System.arraycopy(byArray5, 0, byArray7, 0, n2);
        System.out.println("rawpacket:" + new HexDump(byArray7));
        byArray5 = new byte[1024];
        n = IPSlipUtil.slipEncode(byArray4, 0, byArray4.length, byArray5, 0);
        byArray6 = new byte[n];
        System.arraycopy(byArray5, 0, byArray6, 0, n);
        System.out.println("slipencoded:" + new HexDump(byArray6));
        n2 = IPSlipUtil.slipDecode(byArray6, 1, byArray6.length - 1, byArray5, 0);
        byArray7 = new byte[n2];
        System.arraycopy(byArray5, 0, byArray7, 0, n2);
        System.out.println("rawpacket:" + new HexDump(byArray7));
    }

    public static boolean isValidIPv4(byte[] byArray, int n, int n2) {
        return n2 > 20 && (byArray[0] & 0xF0) == 64;
    }

    public static byte[] getTargetIPFromIPv4Packet(byte[] byArray, int n) {
        byte[] byArray2 = new byte[]{byArray[n + 16], byArray[n + 17], byArray[n + 18], byArray[n + 19]};
        return byArray2;
    }

    public static byte[] getSourceIPFromIPv4Packet(byte[] byArray, int n) {
        byte[] byArray2 = new byte[]{byArray[n + 12], byArray[n + 13], byArray[n + 14], byArray[n + 15]};
        return byArray2;
    }

    public static String convertIPToString(byte[] byArray) {
        return (byArray[0] & 0xFF) + "." + (byArray[1] & 0xFF) + "." + (byArray[2] & 0xFF) + "." + (byArray[3] & 0xFF);
    }

    public static int slipEncode(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (byArray2.length - n3 < 2) {
            throw new IllegalArgumentException(" length of output buffer must be at least 2 bytes");
        }
        if (n + n2 > byArray.length) {
            throw new IllegalArgumentException(" input indices extend past the end of input bytes");
        }
        int n4 = n3;
        byArray2[n4++] = -64;
        block4: for (int i = n; i < n2 + n; ++i) {
            switch (byArray[i]) {
                case -64: {
                    byArray2[n4++] = -37;
                    byArray2[n4++] = -36;
                    continue block4;
                }
                case -37: {
                    byArray2[n4++] = -37;
                    byArray2[n4++] = -35;
                    continue block4;
                }
                default: {
                    byArray2[n4++] = byArray[i];
                }
            }
        }
        byArray2[n4++] = -64;
        return n4 - n3;
    }

    public static int slipDecode(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (n + n2 > byArray.length) {
            throw new IllegalArgumentException(" input indices extend past the end of input bytes");
        }
        int n4 = n;
        int n5 = n3;
        block8: while (n4 < n + n2) {
            switch (byArray[n4]) {
                case -64: {
                    return n5 - n3;
                }
                case -37: {
                    switch (byArray[n4 + 1]) {
                        case -36: {
                            byArray2[n5++] = -64;
                            break;
                        }
                        case -35: {
                            byArray2[n5++] = -37;
                            break;
                        }
                        default: {
                            byArray2[n5++] = byArray[n4 + 1];
                        }
                    }
                    n4 += 2;
                    continue block8;
                }
            }
            byArray2[n5++] = byArray[n4++];
        }
        return n5 - n3;
    }
}

